<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T16:29:32.437326792 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Neoverse-V1" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Bound">
        <series color="19,148,180" description="This metric is the percentage of total slots that were stalled due to resource constraints in the backend of the processor" expression="if(($BackendBoundNeoverseV1CPU_CYCLES &gt; 0), min(($BackendBoundNeoverseV1STALL_SLOT_BACKEND / (8 * $BackendBoundNeoverseV1CPU_CYCLES)), 1), 0)" name="Backend Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Memory Bound">
        <series color="19,148,180" description="This metric is the percentage of backend stalled cycles that were stalled due a miss in the last level of cache" expression="if(($BackendMemoryBoundNeoverseV1STALL_BACKEND &gt; 0), min(($BackendMemoryBoundNeoverseV1STALL_BACKEND_MEM / $BackendMemoryBoundNeoverseV1STALL_BACKEND), 1), 0)" name="Backend Memory Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Stalled Cycles">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesNeoverseV1CPU_CYCLES &gt; 0), min(($BackendStalledCyclesNeoverseV1STALL_BACKEND / $BackendStalledCyclesNeoverseV1CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Bad Speculation">
        <series color="19,148,180" description="This metric is the percentage of total slots that executed operations and didn't retire due to a pipeline flush This indicates cycles that were utilized but inefficiently" expression="if(($BadSpeculationNeoverseV1CPU_CYCLES &gt; 0) &amp;&amp; ($BadSpeculationNeoverseV1OP_SPEC &gt; 0), min((((1 - ($BadSpeculationNeoverseV1OP_RETIRED / $BadSpeculationNeoverseV1OP_SPEC)) * (1 - ($BadSpeculationNeoverseV1STALL_SLOT / ($BadSpeculationNeoverseV1CPU_CYCLES * 8)))) + (($BadSpeculationNeoverseV1BR_MIS_PRED * 4) / $BadSpeculationNeoverseV1CPU_CYCLES)), 1), 0)" name="Bad Speculation" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Barrier Operations Percentage">
        <series color="19,148,180" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageNeoverseV1INST_SPEC &gt; 0), min(((($BarrierOperationsPercentageNeoverseV1ISB_SPEC + $BarrierOperationsPercentageNeoverseV1DSB_SPEC) + $BarrierOperationsPercentageNeoverseV1DMB_SPEC) / $BarrierOperationsPercentageNeoverseV1INST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Misprediction Percentage">
        <series color="19,148,180" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageNeoverseV1BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageNeoverseV1BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageNeoverseV1BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch MPKI">
        <series color="19,148,180" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKINeoverseV1INST_RETIRED &gt; 0), (($BranchMPKINeoverseV1BR_MIS_PRED_RETIRED / $BranchMPKINeoverseV1INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Operations Percentage">
        <series color="19,148,180" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageNeoverseV1INST_SPEC &gt; 0), min((($BranchOperationsPercentageNeoverseV1BR_IMMED_SPEC + $BranchOperationsPercentageNeoverseV1BR_INDIRECT_SPEC) / $BranchOperationsPercentageNeoverseV1INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Cycles Per Instruction">
        <series color="19,148,180" description="This metric measures the number of cycles per instructions retired" expression="if(($CyclesPerInstructionNeoverseV1INST_RETIRED &gt; 0), ($CyclesPerInstructionNeoverseV1CPU_CYCLES / $CyclesPerInstructionNeoverseV1INST_RETIRED), 0)" name="Cycles Per Instruction" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Crypto Operations Percentage">
        <series color="19,148,180" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageNeoverseV1INST_SPEC &gt; 0), min(($CryptoOperationsPercentageNeoverseV1CRYPTO_SPEC / $CryptoOperationsPercentageNeoverseV1INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="DTLB MPKI">
        <series color="19,148,180" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKINeoverseV1INST_RETIRED &gt; 0), (($DTLBMPKINeoverseV1DTLB_WALK / $DTLBMPKINeoverseV1INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="DTLB Walk Percentage">
        <series color="19,148,180" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageNeoverseV1L1D_TLB &gt; 0), min(($DTLBWalkPercentageNeoverseV1DTLB_WALK / $DTLBWalkPercentageNeoverseV1L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Floating Point Operations per Cycle">
        <series color="19,148,180" description="This metric measures floating point operations per cycle in any precision performed by any instruction. Operations are counted by computation and by vector lanes, fused computations such as multiply-add count as twice per vector lane for example." expression="if(($FloatingPointOperationsPerCycleNeoverseV1CPU_CYCLES &gt; 0), (($FloatingPointOperationsPerCycleNeoverseV1FP_SCALE_OPS_SPEC + $FloatingPointOperationsPerCycleNeoverseV1FP_FIXED_OPS_SPEC) / $FloatingPointOperationsPerCycleNeoverseV1CPU_CYCLES), 0)" name="Floating Point Operations per Cycle" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Bound">
        <series color="19,148,180" description="This metric is the percentage of total slots that were stalled due to resource constraints in the frontend of the processor" expression="if(($FrontendBoundNeoverseV1CPU_CYCLES &gt; 0), min((($FrontendBoundNeoverseV1STALL_SLOT_FRONTEND / ($FrontendBoundNeoverseV1CPU_CYCLES * 8)) - (($FrontendBoundNeoverseV1BR_MIS_PRED * 4) / $FrontendBoundNeoverseV1CPU_CYCLES)), 1), 0)" name="Frontend Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Stalled Cycles">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesNeoverseV1CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesNeoverseV1STALL_FRONTEND / $FrontendStalledCyclesNeoverseV1CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageNeoverseV1INST_SPEC &gt; 0), min(($IntegerOperationsPercentageNeoverseV1DP_SPEC / $IntegerOperationsPercentageNeoverseV1INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions Per Cycle">
        <series color="19,148,180" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleNeoverseV1CPU_CYCLES &gt; 0), ($InstructionsPerCycleNeoverseV1INST_RETIRED / $InstructionsPerCycleNeoverseV1CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="ITLB MPKI">
        <series color="19,148,180" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKINeoverseV1INST_RETIRED &gt; 0), (($ITLBMPKINeoverseV1ITLB_WALK / $ITLBMPKINeoverseV1INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="ITLB Walk Percentage">
        <series color="19,148,180" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageNeoverseV1L1I_TLB &gt; 0), min(($ITLBWalkPercentageNeoverseV1ITLB_WALK / $ITLBWalkPercentageNeoverseV1L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Cache Demand MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheDemandMPKINeoverseV1INST_RETIRED &gt; 0), ((($L1DCacheDemandMPKINeoverseV1L1D_CACHE_REFILL_RD + $L1DCacheDemandMPKINeoverseV1L1D_CACHE_REFILL_WR) / $L1DCacheDemandMPKINeoverseV1INST_RETIRED) * 1000), 0)" name="L1D Cache Demand MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageNeoverseV1L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageNeoverseV1L1D_CACHE_REFILL / $L1DCacheMissPercentageNeoverseV1L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKINeoverseV1INST_RETIRED &gt; 0), (($L1DCacheMPKINeoverseV1L1D_CACHE_REFILL / $L1DCacheMPKINeoverseV1INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageNeoverseV1L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageNeoverseV1L1D_TLB_REFILL / $L1DataTLBMissPercentageNeoverseV1L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKINeoverseV1INST_RETIRED &gt; 0), (($L1DataTLBMPKINeoverseV1L1D_TLB_REFILL / $L1DataTLBMPKINeoverseV1INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1I Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageNeoverseV1L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageNeoverseV1L1I_CACHE_REFILL / $L1ICacheMissPercentageNeoverseV1L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1I Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKINeoverseV1INST_RETIRED &gt; 0), (($L1ICacheMPKINeoverseV1L1I_CACHE_REFILL / $L1ICacheMPKINeoverseV1INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageNeoverseV1L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageNeoverseV1L1I_TLB_REFILL / $L1InstructionTLBMissPercentageNeoverseV1L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKINeoverseV1INST_RETIRED &gt; 0), (($L1InstructionTLBMPKINeoverseV1L1I_TLB_REFILL / $L1InstructionTLBMPKINeoverseV1INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageNeoverseV1L2D_CACHE &gt; 0), min(($L2CacheMissPercentageNeoverseV1L2D_CACHE_REFILL / $L2CacheMissPercentageNeoverseV1L2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKINeoverseV1INST_RETIRED &gt; 0), (($L2CacheMPKINeoverseV1L2D_CACHE_REFILL / $L2CacheMPKINeoverseV1INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageNeoverseV1L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageNeoverseV1L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageNeoverseV1L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKINeoverseV1INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKINeoverseV1L2D_TLB_REFILL / $L2UnifiedTLBMPKINeoverseV1INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2D Cache Demand MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache data demand accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheDemandMPKINeoverseV1INST_RETIRED &gt; 0), ((($L2DCacheDemandMPKINeoverseV1L2D_CACHE_REFILL_RD + $L2DCacheDemandMPKINeoverseV1L2D_CACHE_REFILL_WR) / $L2DCacheDemandMPKINeoverseV1INST_RETIRED) * 1000), 0)" name="L2D Cache Demand MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache data accesses missed to the total number of level 2 data cache accesses. This gives an indication of the effectiveness of data accesses in the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMissPercentageNeoverseV1L2D_CACHE &gt; 0), min(($L2DCacheMissPercentageNeoverseV1L2D_CACHE_REFILL / $L2DCacheMissPercentageNeoverseV1L2D_CACHE), 1), 0)" name="L2D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache data accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMPKINeoverseV1INST_RETIRED &gt; 0), (($L2DCacheMPKINeoverseV1L2D_CACHE_REFILL / $L2DCacheMPKINeoverseV1INST_RETIRED) * 1000), 0)" name="L2D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageNeoverseV1L3D_CACHE &gt; 0), min(($L3CacheMissPercentageNeoverseV1L3D_CACHE_REFILL / $L3CacheMissPercentageNeoverseV1L3D_CACHE), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKINeoverseV1INST_RETIRED &gt; 0), (($L3CacheMPKINeoverseV1L3D_CACHE_REFILL / $L3CacheMPKINeoverseV1INST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load-Exclusive Instructions Percentage">
        <series color="19,148,180" description="This metric measures load-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($LoadExclusiveInstructionsPercentageNeoverseV1INST_SPEC &gt; 0), min(($LoadExclusiveInstructionsPercentageNeoverseV1LDREX_SPEC / $LoadExclusiveInstructionsPercentageNeoverseV1INST_SPEC), 1), 0)" name="Load-Exclusive Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LL Cache Read Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageNeoverseV1LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageNeoverseV1LL_CACHE_RD - $LLCacheReadHitPercentageNeoverseV1LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageNeoverseV1LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LL Cache Read Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageNeoverseV1LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageNeoverseV1LL_CACHE_MISS_RD / $LLCacheReadMissPercentageNeoverseV1LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="LL Cache Read MPKI">
        <series color="19,148,180" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKINeoverseV1INST_RETIRED &gt; 0), (($LLCacheReadMPKINeoverseV1LL_CACHE_MISS_RD / $LLCacheReadMPKINeoverseV1INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load Operations Percentage">
        <series color="19,148,180" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageNeoverseV1INST_SPEC &gt; 0), min(($LoadOperationsPercentageNeoverseV1LD_SPEC / $LoadOperationsPercentageNeoverseV1INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Non-SVE Floating Point Operations per Cycle">
        <series color="19,148,180" description="This metric measures floating point operations per cycle in any precision performed by an instruction that is not an SVE instruction. Operations are counted by computation and by vector lanes, fused computations such as multiply-add count as twice per vector lane for example." expression="if(($NonSVEFloatingPointOperationsPerCycleNeoverseV1CPU_CYCLES &gt; 0), ($NonSVEFloatingPointOperationsPerCycleNeoverseV1FP_FIXED_OPS_SPEC / $NonSVEFloatingPointOperationsPerCycleNeoverseV1CPU_CYCLES), 0)" name="Non-SVE Floating Point Operations per Cycle" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load-Acquire Instructions Percentage">
        <series color="19,148,180" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageNeoverseV1INST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageNeoverseV1RC_LD_SPEC / $LoadAcquireInstructionsPercentageNeoverseV1INST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Release Instructions Percentage">
        <series color="19,148,180" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageNeoverseV1INST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageNeoverseV1RC_ST_SPEC / $StoreReleaseInstructionsPercentageNeoverseV1INST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Retired Operations Percentage">
        <series color="19,148,180" description="This metric measures the percentage of operations speculatively executed that are subsequently retired" expression="if(($RetiredOperationsPercentageNeoverseV1OP_SPEC &gt; 0), min(($RetiredOperationsPercentageNeoverseV1OP_RETIRED / $RetiredOperationsPercentageNeoverseV1OP_SPEC), 1), 0)" name="Retired Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Retiring">
        <series color="19,148,180" description="This metric is the percentage of total slots that retired operations, which indicates cycles that were utilized efficiently" expression="if(($RetiringNeoverseV1CPU_CYCLES &gt; 0) &amp;&amp; ($RetiringNeoverseV1OP_SPEC &gt; 0), min(((1 - ($RetiringNeoverseV1STALL_SLOT / ($RetiringNeoverseV1CPU_CYCLES * 8))) * ($RetiringNeoverseV1OP_RETIRED / $RetiringNeoverseV1OP_SPEC)), 1), 0)" name="Retiring" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageNeoverseV1INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageNeoverseV1VFP_SPEC / $FloatingPointOperationsPercentageNeoverseV1INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Advanced SIMD Operations Percentage">
        <series color="19,148,180" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageNeoverseV1INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageNeoverseV1ASE_SPEC / $AdvancedSIMDOperationsPercentageNeoverseV1INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store Operations Percentage">
        <series color="19,148,180" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageNeoverseV1INST_SPEC &gt; 0), min(($StoreOperationsPercentageNeoverseV1ST_SPEC / $StoreOperationsPercentageNeoverseV1INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Store-Exclusive Failures PKI">
        <series color="19,148,180" description="This metric measures the number of store-exclusive instructions that failed per thousand instructions speculatively executed" expression="if(($StoreExclusiveFailuresPKINeoverseV1INST_SPEC &gt; 0), (($StoreExclusiveFailuresPKINeoverseV1STREX_FAIL_SPEC / $StoreExclusiveFailuresPKINeoverseV1INST_SPEC) * 1000), 0)" name="Store-Exclusive Failures PKI" units="failures"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Exclusive Failures Percentage">
        <series color="19,148,180" description="This metric measures the number of store-exclusive instructions that failed as a percentage of store-exclusive instructions speculatively executed" expression="if(($StoreExclusiveFailuresPercentageNeoverseV1STREX_SPEC &gt; 0), min(($StoreExclusiveFailuresPercentageNeoverseV1STREX_FAIL_SPEC / $StoreExclusiveFailuresPercentageNeoverseV1STREX_SPEC), 1), 0)" name="Store-Exclusive Failures Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Exclusive Instructions Percentage">
        <series color="19,148,180" description="This metric measures store-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($StoreExclusiveInstructionsPercentageNeoverseV1INST_SPEC &gt; 0), min(($StoreExclusiveInstructionsPercentageNeoverseV1STREX_SPEC / $StoreExclusiveInstructionsPercentageNeoverseV1INST_SPEC), 1), 0)" name="Store-Exclusive Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Operations (Load/Store Inclusive) Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations, including loads and stores, as a percentage of operations speculatively executed" expression="if(($SVEOperationsLoadStoreInclusivePercentageNeoverseV1INST_SPEC &gt; 0), min(($SVEOperationsLoadStoreInclusivePercentageNeoverseV1SVE_INST_SPEC / $SVEOperationsLoadStoreInclusivePercentageNeoverseV1INST_SPEC), 1), 0)" name="SVE Operations (Load/Store Inclusive) Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SVE Floating Point Operations per Cycle">
        <series color="19,148,180" description="This metric measures floating point operations per cycle in any precision performed by SVE instructions. Operations are counted by computation and by vector lanes, fused computations such as multiply-add count as twice per vector lane for example." expression="if(($SVEFloatingPointOperationsPerCycleNeoverseV1CPU_CYCLES &gt; 0), ($SVEFloatingPointOperationsPerCycleNeoverseV1FP_SCALE_OPS_SPEC / $SVEFloatingPointOperationsPerCycleNeoverseV1CPU_CYCLES), 0)" name="SVE Floating Point Operations per Cycle" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Empty Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with no active predicates as a percentage of sve predicated operations speculatively executed" expression="if(($SVEEmptyPredicatePercentageNeoverseV1SVE_PRED_SPEC &gt; 0), min(($SVEEmptyPredicatePercentageNeoverseV1SVE_PRED_EMPTY_SPEC / $SVEEmptyPredicatePercentageNeoverseV1SVE_PRED_SPEC), 1), 0)" name="SVE Empty Predicate Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Full Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with all active predicates as a percentage of sve predicated operations speculatively executed" expression="if(($SVEFullPredicatePercentageNeoverseV1SVE_PRED_SPEC &gt; 0), min(($SVEFullPredicatePercentageNeoverseV1SVE_PRED_FULL_SPEC / $SVEFullPredicatePercentageNeoverseV1SVE_PRED_SPEC), 1), 0)" name="SVE Full Predicate Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Partial Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with at least one active predicates as a percentage of sve predicated operations speculatively executed" expression="if(($SVEPartialPredicatePercentageNeoverseV1SVE_PRED_SPEC &gt; 0), min(($SVEPartialPredicatePercentageNeoverseV1SVE_PRED_PARTIAL_SPEC / $SVEPartialPredicatePercentageNeoverseV1SVE_PRED_SPEC), 1), 0)" name="SVE Partial Predicate Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with predicates as a percentage of operations speculatively executed" expression="if(($SVEPredicatePercentageNeoverseV1INST_SPEC &gt; 0), min(($SVEPredicatePercentageNeoverseV1SVE_PRED_SPEC / $SVEPredicatePercentageNeoverseV1INST_SPEC), 1), 0)" name="SVE Predicate Percentage" units="percent"/>
    </chart>
    <select-metric id="ARMv8_Neoverse_V1_metric_backend_bound" />
    <select-metric id="ARMv8_Neoverse_V1_metric_backend_mem_bound" />
    <select-metric id="ARMv8_Neoverse_V1_metric_backend_stalled_cycles" />
    <select-metric id="ARMv8_Neoverse_V1_metric_bad_speculation" />
    <select-metric id="ARMv8_Neoverse_V1_metric_barrier_percentage" />
    <select-metric id="ARMv8_Neoverse_V1_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv8_Neoverse_V1_metric_branch_mpki" />
    <select-metric id="ARMv8_Neoverse_V1_metric_branch_percentage" />
    <select-metric id="ARMv8_Neoverse_V1_metric_cpi" />
    <select-metric id="ARMv8_Neoverse_V1_metric_crypto_percentage" />
    <select-metric id="ARMv8_Neoverse_V1_metric_dtlb_mpki" />
    <select-metric id="ARMv8_Neoverse_V1_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv8_Neoverse_V1_metric_fp_ops_per_cycle" />
    <select-metric id="ARMv8_Neoverse_V1_metric_frontend_bound" />
    <select-metric id="ARMv8_Neoverse_V1_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv8_Neoverse_V1_metric_integer_dp_percentage" />
    <select-metric id="ARMv8_Neoverse_V1_metric_ipc" />
    <select-metric id="ARMv8_Neoverse_V1_metric_itlb_mpki" />
    <select-metric id="ARMv8_Neoverse_V1_metric_itlb_walk_ratio" />
    <select-metric id="ARMv8_Neoverse_V1_metric_l1d_cache_demand_mpki" />
    <select-metric id="ARMv8_Neoverse_V1_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_V1_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_V1_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_V1_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Neoverse_V1_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_V1_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_V1_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_V1_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv8_Neoverse_V1_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_V1_metric_l2_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_V1_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_V1_metric_l2_tlb_mpki" />
    <select-metric id="ARMv8_Neoverse_V1_metric_l2d_cache_demand_mpki" />
    <select-metric id="ARMv8_Neoverse_V1_metric_l2d_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_V1_metric_l2d_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_V1_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_V1_metric_l3_cache_mpki" />
    <select-metric id="ARMv8_Neoverse_V1_metric_ldrex_percentage" />
    <select-metric id="ARMv8_Neoverse_V1_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv8_Neoverse_V1_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv8_Neoverse_V1_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv8_Neoverse_V1_metric_load_percentage" />
    <select-metric id="ARMv8_Neoverse_V1_metric_nonsve_fp_ops_per_cycle" />
    <select-metric id="ARMv8_Neoverse_V1_metric_rc_ld_percentage" />
    <select-metric id="ARMv8_Neoverse_V1_metric_rc_st_percentage" />
    <select-metric id="ARMv8_Neoverse_V1_metric_retired_ops_percent" />
    <select-metric id="ARMv8_Neoverse_V1_metric_retiring" />
    <select-metric id="ARMv8_Neoverse_V1_metric_scalar_fp_percentage" />
    <select-metric id="ARMv8_Neoverse_V1_metric_simd_percentage" />
    <select-metric id="ARMv8_Neoverse_V1_metric_store_percentage" />
    <select-metric id="ARMv8_Neoverse_V1_metric_strex_fail_mpki" />
    <select-metric id="ARMv8_Neoverse_V1_metric_strex_fail_percent" />
    <select-metric id="ARMv8_Neoverse_V1_metric_strex_percentage" />
    <select-metric id="ARMv8_Neoverse_V1_metric_sve_all_percentage" />
    <select-metric id="ARMv8_Neoverse_V1_metric_sve_fp_ops_per_cycle" />
    <select-metric id="ARMv8_Neoverse_V1_metric_sve_predicate_empty_percentage" />
    <select-metric id="ARMv8_Neoverse_V1_metric_sve_predicate_full_percentage" />
    <select-metric id="ARMv8_Neoverse_V1_metric_sve_predicate_partial_percentage" />
    <select-metric id="ARMv8_Neoverse_V1_metric_sve_predicate_percentage" />
</template>
